% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAPS_dens.R
\name{LAPS_dens}
\alias{LAPS_dens}
\title{Bayesian density estimation}
\usage{
LAPS_dens(B, P, y, loglambdas, tol = 1e-05, mon = FALSE)
}
\arguments{
\item{B}{matrix (\code{m} by \code{n}) with B-spline basis, see \code{bbase()}.}

\item{P}{penalty matrix (\code{n} by \code{n}).}

\item{y}{vector (length \code{m}) of counts, usually a histogram.}

\item{loglambdas}{a vector of values of logarithms of \code{lambda} to explore.}

\item{tol}{convergence tolerance (relative change in coefficients), default \code{1e-5}.}

\item{mon}{TRUE or FALSE to monitor the iteration history (default FALSE).}
}
\value{
A list with elements:
\item{alpha}{P-spline coefficients of length \code{n}.}
\item{weights}{weights from the Laplace approximation, which sum to 1 and are
the same length as \code{loglambdas}.}
\item{mu}{a vector of length \code{m} of expected values.}
\item{Cov}{covariance matrix (\code{m} by \code{m}) of \code{log(mu)}.}
\item{lambda}{the penalty parameter.}
\item{ed}{the effective model dimension.}
}
\description{
Bayesian density estimation with P-splines and Laplace approximation.
}
\details{
The B-spline basis should be based on the midpoints of the histogram bins.
See the example below.
This function is based on the paper of Gressani and Lambert (2018) and code input by Oswaldo Gressani.
}
\examples{
# Smoothing a histogram of Old Faithful eruption durations
data(faithful)
durations = faithful[, 1]  # Eruption length

# Histogram with narrow bin widths
bw = 0.05
hst = hist(durations, breaks = seq(1, 6, by = bw), plot = TRUE)
x = hst$mids
y = hst$counts

# B-spline basis matrices, for fitting and plotting
nseg = 30
B = bbase(x, nseg = nseg)
xg = seq(min(x), max(x), by = 0.01)
Bg = bbase(xg, nseg = nseg)
n = ncol(B)

# Penalty matrix
D2 = diff(diag(n), diff = 2)
P2 = t(D2) \%*\% D2

# Fit the model
loglambs = seq(-1, 2, by = 0.05)
laps2 = LAPS_dens(B, P2, y, loglambs, mon = FALSE)
fhat2 = exp(Bg \%*\% laps2$alpha)
lines(xg, fhat2, col = "blue", lwd = 2)
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Gressani, O. and Lambert, P. (2018).
Fast Bayesian inference using Laplace approximations in a flexible promotion time cure model based on P-splines.
\emph{Computational Statistics and Data Analysis} 124, 151-167.
}
\author{
Paul Eilers
}
