% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim_psr.R
\name{plot.simpsr}
\alias{plot.simpsr}
\title{Plotting function for \code{sim_psr}}
\usage{
\method{plot}{simpsr}(x, ..., xlab = " ", ylab = " ", Resol = 100)
}
\arguments{
\item{x}{the P-spline object, usually from \code{sim_psr}.}

\item{...}{other parameters.}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{Resol}{resolution for plotting, default \code{Resol = 100}.}
}
\value{
\item{Plot}{a two panel plot, one for the estimated P-spline signal coefficent vector, and another for
the estimated (unkown) P-spline smooth link function.}
}
\description{
Plotting function for single-index signal
regression with tensor product P-splines (using \code{sim_psr} with \code{class simpsr}).
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40])
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]

pords <- c(2, 2)
nsegs <- c(27, 7)
bdegs = c(3, 3)
lambdas <- c(1e-6, .1)
max_iter <- 100

# Single-index model
fit <- sim_psr(y, dX, diindex, nsegs, bdegs, lambdas, pords,
             max_iter)
plot(fit, xlab = "Wavelength (nm)", ylab = " ")

}
\references{
Eilers, P.H.C., B. Li, B.D. Marx (2009).
Multivariate calibration with single-index signal regression,
\emph{Chemometrics and Intellegent Laboratory Systems}, 96(2), 196-202.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers, Brian Marx, and Bin Li
}
