# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The Classical Jacobi Algorithm in Compiled Code
#'
#' Eigenvalues and optionally, eigenvectore, of a real symmetric matrix using the
#' classical Jacobi algorithm, (Jacobi, 1854)
#' @import Rcpp
#' @useDynLib JacobiEigen
#' @title The Jacobi Algorithm using Rcpp
#' @param x A real symmetric matrix
#' @param only_values A logical value: do you want eigenvalues only?
#' @param eps an error tolerance. 0.0 implies \code{.Machine$double.eps} and
#'   \code{sqrt(.Machine$double.eps)} if \code{only_values = TRUE
#'   }
#' @export JacobiCpp
#' @examples
#' V <- crossprod(matrix(1:25, 5))
#' JacobiCpp(V)
#' identical(JacobiCpp(V), JacobiR(V))
#' all.equal(JacobiCpp(V)$values, base::eigen(V)$values)
#' @return a list of two components as for \code{base::eigen}
JacobiCpp <- function(x, only_values = FALSE, eps = 0.0) {
    .Call('JacobiEigen_JacobiCpp', PACKAGE = 'JacobiEigen', x, only_values, eps)
}

