% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JacobiR.R
\name{JacobiS}
\alias{JacobiS}
\title{The Jacobi Algorithm using Rcpp with a stagewise rotation protocol}
\usage{
JacobiS(x, symmetric = TRUE, only.values = FALSE, eps = 0)
}
\arguments{
\item{x}{A real symmetric matrix}

\item{symmetric}{a logical value.  Is the matrix symmetric?  (Only symmetric matrices are allowed.)}

\item{only.values}{A logical value: do you want only the eigenvalues?}

\item{eps}{an error tolerance. 0.0 implies \code{.Machine$double.eps} and
\code{sqrt(.Machine$double.eps)} if \code{only.values = TRUE}}
}
\value{
a list of two components as for \code{base::eigen}
}
\description{
The Classical Jacobi Algorithm with a stagewise protocol
}
\details{
Eigenvalues and optionally, eigenvectore, of a real symmetric matrix using the
classical Jacobi algorithm, (Jacobi, 1846) using a stagewise rotation protocol
}
\examples{
V <- crossprod(matrix(runif(40, -1, 1), 8))
JacobiS(V)
all.equal(JacobiS(V)$values, Jacobi(V)$values)
zapsmall(crossprod(JacobiS(V)$vectors, Jacobi(V)$vectors))
}
