% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_hospital_beds.R
\name{get_japan_hospital_beds}
\alias{get_japan_hospital_beds}
\title{Get Hospital Beds per 1,000 People in Japan from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SH.MED.BEDS.ZS}
}
\usage{
get_japan_hospital_beds()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Hospital beds (per 1,000 people)")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Hospital beds per 1,000 people (numeric)
}
}
\description{
Retrieves data on the number of hospital beds per 1,000 people in Japan
from 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SH.MED.BEDS.ZS}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_japan_hospital_beds()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
