/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRGrammarParseBehavior;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.LLkAnalyzer;
import antlr.LexerGrammar;
import antlr.ParserGrammar;
import antlr.RuleSymbol;
import antlr.SemanticException;
import antlr.SimpleTokenManager;
import antlr.StringLiteralSymbol;
import antlr.TokdefTokenManager;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeWalkerGrammar;
import antlr.collections.impl.BitSet;
import java.util.Hashtable;

public class DefineGrammarSymbols
implements ANTLRGrammarParseBehavior {
    protected Hashtable grammars = new Hashtable();
    protected Hashtable tokenManagers = new Hashtable();
    protected Grammar grammar;
    protected Tool tool;
    LLkAnalyzer analyzer;
    String[] args;
    static final String DEFAULT_TOKENMANAGER_NAME = "*default";
    protected String headerAction;
    String thePreambleAction;
    String language = "Java";

    public DefineGrammarSymbols(Tool tool, String[] stringArray, LLkAnalyzer lLkAnalyzer) {
        this.tool = tool;
        this.args = stringArray;
        this.analyzer = lLkAnalyzer;
    }

    public void abortGrammar() {
        if (this.grammar != null && this.grammar.getClassName() != null) {
            this.grammars.remove(this.grammar.getClassName());
        }
        this.grammar = null;
    }

    public void beginAlt(boolean bl) {
    }

    public void beginChildList() {
    }

    public void beginExceptionGroup() {
    }

    public void beginExceptionSpec(Token token) {
    }

    public void beginSubRule(Token token, int n, boolean bl) {
    }

    public void beginTree(int n) throws SemanticException {
    }

    public void defineRuleName(Token token, String string, boolean bl, String string2) throws SemanticException {
        RuleSymbol ruleSymbol;
        String string3 = token.getText();
        if (Character.isUpperCase(string3.charAt(0))) {
            string3 = CodeGenerator.lexerRuleName(string3);
            if (!this.grammar.tokenManager.tokenDefined(token.getText())) {
                int n = this.grammar.tokenManager.nextTokenType();
                if (n != 0) {
                    TokenSymbol tokenSymbol = new TokenSymbol(token.getText());
                    tokenSymbol.setTokenType(n);
                    this.grammar.tokenManager.define(tokenSymbol);
                } else {
                    this.tool.error("You cannot define new tokens when using tokdef", token.getLine());
                }
            }
        }
        if (this.grammar.isDefined(string3)) {
            ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string3);
            if (ruleSymbol.isDefined()) {
                this.tool.error("redefinition of rule " + string3, token.getLine());
            }
        } else {
            ruleSymbol = new RuleSymbol(string3);
            this.grammar.define(ruleSymbol);
        }
        ruleSymbol.setDefined();
        ruleSymbol.access = string;
        ruleSymbol.comment = string2;
    }

    public void endAlt() {
    }

    public void endChildList() {
    }

    public void endExceptionGroup() {
    }

    public void endExceptionSpec() {
    }

    public void endGrammar() {
    }

    public void endOptions() {
        if (this.grammar.tokenManager == null) {
            if (this.tokenManagers.containsKey(DEFAULT_TOKENMANAGER_NAME)) {
                TokenManager tokenManager = (TokenManager)this.tokenManagers.get(DEFAULT_TOKENMANAGER_NAME);
                this.grammar.setTokenManager(tokenManager);
                return;
            }
            SimpleTokenManager simpleTokenManager = new SimpleTokenManager(this.grammar.getClassName(), this.tool);
            this.grammar.setTokenManager(simpleTokenManager);
            this.tokenManagers.put(DEFAULT_TOKENMANAGER_NAME, this.grammar.tokenManager);
        }
    }

    public void endRule(String string) {
    }

    public void endSubRule() {
    }

    public void endTree() {
    }

    public void hasError() {
    }

    public void noASTSubRule() {
    }

    public void oneOrMoreSubRule() {
    }

    public void optionalSubRule() {
    }

    public void refAction(Token token) {
    }

    public void refArgAction(Token token) {
    }

    public void refCharLiteral(Token token, Token token2, boolean bl, int n, boolean bl2) {
    }

    public void refCharRange(Token token, Token token2, Token token3, int n, boolean bl) {
    }

    public void refExceptionHandler(Token token, String string) {
    }

    public void refHeaderAction(Token token) {
        this.headerAction = token.getText();
    }

    public void refInitAction(Token token) {
    }

    public void refMemberAction(Token token) {
    }

    public void refPreambleAction(Token token) {
        this.thePreambleAction = token.getText();
    }

    public void refReturnAction(Token token) {
    }

    public void refRule(Token token, Token token2, Token token3, Token token4, int n) {
        String string = token2.getText();
        if (Character.isUpperCase(string.charAt(0))) {
            string = CodeGenerator.lexerRuleName(string);
        }
        if (!this.grammar.isDefined(string)) {
            this.grammar.define(new RuleSymbol(string));
        }
    }

    public void refSemPred(Token token) {
    }

    public void refStringLiteral(Token token, Token token2, int n, boolean bl) {
        if (!(this.grammar instanceof LexerGrammar)) {
            String string = token.getText();
            if (this.grammar.tokenManager.getTokenSymbol(string) != null) {
                return;
            }
            StringLiteralSymbol stringLiteralSymbol = new StringLiteralSymbol(string);
            int n2 = this.grammar.tokenManager.nextTokenType();
            if (n2 != 0) {
                stringLiteralSymbol.setTokenType(n2);
                this.grammar.tokenManager.define(stringLiteralSymbol);
                return;
            }
            this.tool.error("You cannot define new string literals when using tokdef", token.getLine());
        }
    }

    public void refToken(Token token, Token token2, Token token3, Token token4, boolean bl, int n, boolean bl2) {
        String string = token2.getText();
        if (!this.grammar.tokenManager.tokenDefined(string)) {
            int n2 = this.grammar.tokenManager.nextTokenType();
            if (n2 != 0) {
                TokenSymbol tokenSymbol = new TokenSymbol(string);
                tokenSymbol.setTokenType(n2);
                this.grammar.tokenManager.define(tokenSymbol);
                return;
            }
            this.tool.error("You cannot define new tokens when using tokdef", token2.getLine());
        }
    }

    public void refTokenRange(Token token, Token token2, Token token3, int n, boolean bl) {
        if (token.getText().charAt(0) == '\"') {
            this.refStringLiteral(token, null, 1, bl);
        } else {
            this.refToken(null, token, null, null, false, 1, bl);
        }
        if (token2.getText().charAt(0) == '\"') {
            this.refStringLiteral(token2, null, 1, bl);
            return;
        }
        this.refToken(null, token2, null, null, false, 1, bl);
    }

    public void refTreeSpecifier(Token token) {
    }

    public void refWildcard(Token token, Token token2, int n) {
    }

    public void reset() {
        this.grammar = null;
    }

    public void setArgOfRuleRef(Token token) {
    }

    public void setCharVocabulary(BitSet bitSet) {
        ((LexerGrammar)this.grammar).setCharVocabulary(bitSet);
    }

    public void setFileOption(Token token, Token token2) {
        if (token.getText().equals("language")) {
            if (token2.getType() == 17) {
                this.language = Tool.stripBack(Tool.stripFront(token2.getText(), '\"'), '\"');
                return;
            }
            if (token2.getType() == 23 || token2.getType() == 27) {
                this.language = token2.getText();
                return;
            }
            this.tool.error("language option must be string or identifier", token2.getLine());
            return;
        }
        if (token.getText().equals("mangleLiteralPrefix")) {
            if (token2.getType() == 17) {
                Tool.literalsPrefix = Tool.stripFrontBack(token2.getText(), "\"", "\"");
                return;
            }
            this.tool.error("mangleLiteralPrefix option must be string", token2.getLine());
            return;
        }
        if (token.getText().equals("upperCaseMangledLiterals")) {
            if (token2.getText().equals("true")) {
                Tool.upperCaseMangledLiterals = true;
                return;
            }
            if (token2.getText().equals("false")) {
                Tool.upperCaseMangledLiterals = false;
                return;
            }
            this.grammar.tool.error("Value for upperCaseMangledLiterals must be true or false", token.getLine());
            return;
        }
        this.tool.error("Invalid file-level option: " + token.getText(), token.getLine());
    }

    public void setGrammarOption(Token token, Token token2) {
        if (token.getText().equals("tokenVocabulary")) {
            if (this.grammar.tokenManager != null) {
                this.tool.error("Only one tokdef or tokenVocabulary option may be specified", token2.getLine());
                return;
            }
            if (this.tokenManagers.containsKey(token2.getText())) {
                TokenManager tokenManager = (TokenManager)this.tokenManagers.get(token2.getText());
                if (tokenManager instanceof SimpleTokenManager) {
                    this.grammar.setTokenManager(tokenManager);
                    return;
                }
                this.tool.error("'" + token2.getText() + "' is already defined as something else", token2.getLine());
                return;
            }
            if (token2.getType() == 27 || token2.getType() == 23) {
                SimpleTokenManager simpleTokenManager = new SimpleTokenManager(token2.getText(), this.tool);
                this.tokenManagers.put(simpleTokenManager.getName(), simpleTokenManager);
                this.grammar.setTokenManager(simpleTokenManager);
                return;
            }
            this.tool.error("tokenVocabulary must be an identifier", token2.getLine());
            return;
        }
        if (token.getText().equals("tokdef")) {
            if (this.grammar instanceof LexerGrammar) {
                this.tool.error("tokdef= option cannot be used with a lexer", token.getLine());
                return;
            }
            if (this.grammar.tokenManager != null) {
                this.tool.error("Only one tokdef or tokenVocabulary option may be specified", token2.getLine());
                return;
            }
            if (this.tokenManagers.containsKey(token2.getText())) {
                TokenManager tokenManager = (TokenManager)this.tokenManagers.get(token2.getText());
                if (tokenManager instanceof TokdefTokenManager) {
                    this.grammar.setTokenManager(tokenManager);
                    return;
                }
                this.tool.error("'" + token2.getText() + "' is already defined as something else", token2.getLine());
                return;
            }
            if (token2.getType() == 17) {
                String string = token2.getText();
                string = string.substring(1, string.length() - 1);
                TokdefTokenManager tokdefTokenManager = new TokdefTokenManager(this.grammar, string, this.tool);
                this.tokenManagers.put(tokdefTokenManager.getName(), tokdefTokenManager);
                this.grammar.setTokenManager(tokdefTokenManager);
                return;
            }
            this.tool.error("tokdef filename must be double-quoted", token2.getLine());
            return;
        }
        this.grammar.setOption(token.getText(), token2);
    }

    public void setRuleOption(Token token, Token token2) {
    }

    public void setSubruleOption(Token token, Token token2) {
    }

    public void startLexer(Token token, String string, String string2) {
        this.reset();
        Grammar grammar = (Grammar)this.grammars.get(token);
        if (grammar != null) {
            if (!(grammar instanceof LexerGrammar)) {
                Tool.panic("'" + token.getText() + "' is already defined as a non-lexer");
                return;
            }
            Tool.panic("Lexer '" + token.getText() + "' is already defined");
            return;
        }
        LexerGrammar lexerGrammar = new LexerGrammar(token.getText(), this.tool, string);
        lexerGrammar.comment = string2;
        lexerGrammar.processArguments(this.args);
        this.grammars.put(lexerGrammar.getClassName(), lexerGrammar);
        lexerGrammar.preambleAction = this.thePreambleAction;
        this.thePreambleAction = null;
        this.grammar = lexerGrammar;
    }

    public void startParser(Token token, String string, String string2) {
        this.reset();
        Grammar grammar = (Grammar)this.grammars.get(token);
        if (grammar != null) {
            if (!(grammar instanceof ParserGrammar)) {
                Tool.panic("'" + token.getText() + "' is already defined as a non-parser");
                return;
            }
            Tool.panic("Parser '" + token.getText() + "' is already defined");
            return;
        }
        this.grammar = new ParserGrammar(token.getText(), this.tool, string);
        this.grammar.comment = string2;
        this.grammar.processArguments(this.args);
        this.grammars.put(this.grammar.getClassName(), this.grammar);
        this.grammar.preambleAction = this.thePreambleAction;
        this.thePreambleAction = null;
    }

    public void startTreeWalker(Token token, String string, String string2) {
        this.reset();
        Grammar grammar = (Grammar)this.grammars.get(token);
        if (grammar != null) {
            if (!(grammar instanceof TreeWalkerGrammar)) {
                Tool.panic("'" + token.getText() + "' is already defined as a non-tree-walker");
                return;
            }
            Tool.panic("Tree-walker '" + token.getText() + "' is already defined");
            return;
        }
        this.grammar = new TreeWalkerGrammar(token.getText(), this.tool, string);
        this.grammar.comment = string2;
        this.grammar.processArguments(this.args);
        this.grammars.put(this.grammar.getClassName(), this.grammar);
        this.grammar.preambleAction = this.thePreambleAction;
        this.thePreambleAction = null;
    }

    public void synPred() {
    }

    public void zeroOrMoreSubRule() {
    }
}

