% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation}
\alias{simulation}
\title{simulate multiple sparse graphs and generate samples}
\usage{
simulation(p = 20, n, seedNum = 37, s = 0.1, ss = 0.1)
}
\arguments{
\item{p}{number of features (number of nodes)}

\item{n}{a vector indicating number of samples and tasks, for example c(100,200,300) for 3 tasks and 100,200 and 300 samples for task 1, 2 and 3}

\item{seedNum}{seed number for random simulation}

\item{s}{positive number that controls sparsity of the generated graphs}

\item{ss}{positive number that controls sparsity of the shared part of generated graphs}
}
\value{
a list comprising $simulatedgraphs (multiple related simulated graphs) and $simulatedsamples (samples generated from multiple related graphs)
}
\description{
simulate multiple sparse graphs and generate samples
}
\examples{
library(JointNets)
simulateresult = simulation(p = 20,  n = c(100,100))
plot(simulateresult$simulatedgraphs)
}
