% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsim.R
\name{SV1FJ}
\alias{SV1FJ}
\title{SV1FJ model simulation}
\usage{
SV1FJ(M, m, p0 = 3, lam = 0.2, mu = 0.03, v0 = 0.5, beta0 = 0,
  beta1 = 0.125, alphav = -0.1, cov = -0.62)
}
\arguments{
\item{M}{number of interverals to be simulated}

\item{m}{number of time points within each interval}

\item{p0}{start price}

\item{lam}{frequency of jump}

\item{mu}{drift}

\item{v0}{volatility parameter}

\item{beta0}{underlying Brownian motion intercept paramter}

\item{beta1}{underlying Brownian motion slope parameter}

\item{alphav}{volatility parameter}

\item{cov}{Brownian motion correlation}
}
\value{
simulated time series
}
\description{
Simulate Stochastic Volitility model with one factor model (including jump) with given length and other parameters
}
\examples{
SV1FJ(1000,390)
}
\references{
Chernov, M., et al. (2003). "Alternative models for stock price dynamics." Journal of Econometrics 116(1): 225-257.
}
