% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_parse_table.R
\name{flash_parse_table}
\alias{flash_parse_table}
\alias{get_results_table}
\title{Collects results from a link to a Flash Results page}
\usage{
flash_parse_table(link, wide_format = FALSE, clean = FALSE)

get_results_table(link, wide_format = FALSE, clean = FALSE)
}
\arguments{
\item{link}{a link to an event landing page on flashresults.com}

\item{wide_format}{should results be presented in wide format (defaults to \code{FALSE})}

\item{clean}{should results be cleaned by \code{flash_clean_events}?  Default is \code{FALSE}.}
}
\value{
returns a data frame of results scraped from \code{link}
}
\description{
Used in scraping flashresults.com.  Collects results given in html tables on a specified page into a data frame.
}
\examples{
\donttest{flash_parse_table("https://www.flashresults.com/2019_Meets/Outdoor/06-13_NBNO/067-4_compiled.htm")}

}
