% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeResult.R
\name{writeResult}
\alias{writeResult}
\title{Write data and results to Excel}
\usage{
writeResult(
  resultTable,
  pedigrees,
  linkageMap,
  markerData,
  outfile,
  notes = NULL,
  famname = NULL,
  settings = NULL,
  XML = NULL
)
}
\arguments{
\item{resultTable}{A data frame.}

\item{pedigrees}{A list of two \code{ped} objects.}

\item{linkageMap}{A data frame.}

\item{markerData}{A data frame.}

\item{outfile}{The output file name.}

\item{notes}{A character vector.}

\item{famname}{The name of the input \code{.fam} file.}

\item{settings}{A list of KLINK settings to be included in the output}

\item{XML}{Optional data from .xml file.}
}
\description{
This function produces an Excel document containing the genotype data and
various LR tables.
}
\examples{
\donttest{
# Built-in dataset `paternity`
peds = paternity
map = LINKAGEMAP
mdata = markerSummary(peds)

# Result table
LRtab = linkedLR(pedigrees = peds, linkageMap = map, markerData = mdata)

# Write to excel
tmp = paste0(tempfile(), ".xlsx")
writeResult(LRtab,
            pedigrees = peds,
            linkageMap = map,
            markerData = mdata,
            outfile = tmp)

# openxlsx::openXL(tmp)
}
}
