% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{sim.Kernelheaping}
\alias{sim.Kernelheaping}
\title{Simulation of heaping correction method}
\usage{
sim.Kernelheaping(simRuns, n, distribution, rounds, thresholds,
  downbias = 0.5, setBias = FALSE, Beta = 0, unequal = FALSE,
  burnin = 5, samples = 10, bw = "nrd0", offset = 0, boundary = FALSE,
  adjust = 1, ...)
}
\arguments{
\item{simRuns}{number of simulations runs}

\item{n}{sample size}

\item{distribution}{name of the distribution where random sampling is available, e.g. "norm"}

\item{rounds}{rounding values, numeric vector of length >=1}

\item{thresholds}{rounding thresholds (for Beta=0)}

\item{downbias}{Bias parameter used in the simulation}

\item{setBias}{if TRUE a rounding Bias parameter is estimated. For values above 0.5, the respondents
are more prone to round down, while for values < 0.5 they are more likely to round up}

\item{Beta}{Parameter of the probit model for rounding probabilities used in simulation}

\item{unequal}{if TRUE a probit model is fitted for the rounding probabilities with log(true value) as regressor}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{bw}{bandwidth selector method, defaults to "nrd0" see \code{density} for more options}

\item{offset}{location shift parameter used simulation in simulation}

\item{boundary}{TRUE for positive only data (no positive density for negative values)}

\item{adjust}{as in \code{density}, the user can multiply the bandwidth by a certain factor such that bw=adjust*bw}

\item{...}{additional attributes handed over to \code{createSim.Kernelheaping}}
}
\value{
List of estimation results
}
\description{
Simulation of heaping correction method
}
\examples{
\dontrun{Sims1 <- sim.Kernelheaping(simRuns=2, n=500, distribution="norm",
rounds=c(1,10,100), thresholds=c(0.3,0.4,0.3), sd=100)}
}

