\name{rcpp_apply_generator}
\alias{rcpp_apply_generator}
\alias{Rcpp_apply_generator}
\title{Rcpp Apply Generator}
\usage{
  rcpp_apply_generator(fun, includes = NULL,
    depends = NULL, inline = TRUE, returnType = "double",
    name = NULL, file = NULL, additional = NULL)

  Rcpp_apply_generator(fun, includes = NULL,
    depends = NULL, inline = TRUE, returnType = "double",
    name = NULL, file = NULL, additional = NULL)
}
\arguments{
  \item{fun}{A character string defining the C++ function.
  It must be in terms of a variable \code{x}, and it must
  return a \code{double}. \code{x} is a reference to the
  current row/column being iterated over.}

  \item{includes}{Other C++ libraries to include. For
  example, to include boost/math.hpp, you could pass
  c("<boost/math.hpp>"). Rcpp is included by default,
  unless RcppArmadillo is included as well (since Rcpp is
  included as part of the RcppArmadillo include)}

  \item{depends}{Other libraries to link to. Linking is
  done through Rcpp attributes.}

  \item{inline}{boolean; mark this function as inline? This
  may or may not increase execution speed.}

  \item{returnType}{The return type of your function; must
  be a scalar that is \code{wrap}pable by Rcpp. Currently,
  the supported choices are \code{double}, \code{int}, and
  \code{bool}.}

  \item{name}{An internal name for the function.}

  \item{file}{A location to output the file. Defaults to a
  temporary file as generated by \code{\link{tempfile}()}.}

  \item{additional}{Other C++ code you want to include;
  e.g. helper functions. This code will be inserted as-is
  above the code in \code{fun}.}
}
\description{
  Use this function as a generator for your own
  \code{apply} functions; that is, functions you would like
  to apply over rows or columns of a matrix.
}
\examples{
\dontrun{
x <- matrix(1:16, nrow=4)
cvApply <- rcpp_apply_generator("return mean(x) / sd(x);")
squaredSumApply <- rcpp_apply_generator("
  double out = 0;
  for( int i=0; i < x.size(); i++ ) {
    out += x[i];
    }
  out = out*out;
  return out;
  ")
cvApply(x, 2)
apply(x, 2, mean) / apply(x, 2, sd)
if( require(microbenchmark) ) {
 f <- function(x) { mean(x) / sd(x) }
 microbenchmark( cvApply(x, 2), apply(x, 2, f) )
}
## example with bool
anyBig <- rcpp_apply_generator( returnType="bool", '
  return is_true( any( x > 10 ) );
  ')
anyBig(x, 2)
anyBig(x, 1)
## example with boost's gcd. silly but demonstrative.
## intended to be applied to matrices with 2 rows and n columns
gcdApply <- rcpp_apply_generator(
  includes="<boost/math/common_factor.hpp>",
  fun='
  NumericVector tmp1 = x;
  std::vector<int> tmp = as< std::vector< int > >(tmp1);
  return boost::math::gcd( tmp[0], tmp[1] );
  ')
M <- matrix( c(4, 6, 20, 25, 10, 100), nrow=2 )
gcdApply(M, 2)
}
}

