/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.utils.MorphUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisOutput
implements Cloneable {
    public static final int SCORE_CORRECT = 100;
    public static final int SCORE_COMPOUNDS = 70;
    public static final int SCORE_ANALYSIS = 30;
    public static final int SCORE_CANDIDATE = 10;
    public static final int SCORE_FAIL = 0;
    private String source;
    private int score;
    private int patn;
    private char type;
    private List<CompoundEntry> compound = new ArrayList<CompoundEntry>();
    private String stem;
    private char pos;
    private char pos2;
    private char dinf;
    private String nsfx;
    private String josa;
    private List<String> jlist = new ArrayList<String>();
    private String eomi;
    private List<String> elist = new ArrayList<String>();
    private String pomi;
    private String xverb;
    private String vsfx;
    private char vtype;

    public AnalysisOutput() {
        this.score = 0;
    }

    public AnalysisOutput(String stem, String josa, String eomi, int patn) {
        this.score = 30;
        this.stem = stem;
        this.josa = josa;
        this.eomi = eomi;
        this.patn = patn;
    }

    public AnalysisOutput(String stem, String josa, String eomi, int patn, int score) {
        this(stem, josa, eomi, patn);
        this.score = score;
    }

    public AnalysisOutput(String stem, String josa, String eomi, char pos, int patn, int score) {
        this(stem, josa, eomi, patn, score);
        this.pos = pos;
    }

    public void setScore(int i) {
        this.score = i;
    }

    public void setPatn(int i) {
        this.patn = i;
    }

    public void setType(char c) {
        this.type = c;
    }

    public void setStem(String s) {
        this.stem = s;
    }

    public void setPos(char c) {
        this.pos = c;
    }

    public void setPos2(char c) {
        this.pos2 = c;
    }

    public void setDinf(char c) {
        this.dinf = c;
    }

    public void setNsfx(String s) {
        this.nsfx = s;
    }

    public void setJosa(String s) {
        this.josa = s;
    }

    public void addJlist(String l) {
        this.jlist.add(l);
    }

    public void setEomi(String s) {
        this.eomi = s;
    }

    public void addElist(String l) {
        this.elist.add(l);
    }

    public void setElist(String l, int index) {
        this.elist.set(index, l);
    }

    public void setPomi(String s) {
        this.pomi = s;
    }

    public void setXverb(String s) {
        this.xverb = s;
    }

    public void setVsfx(String s) {
        this.vsfx = s;
    }

    public void setVtype(char c) {
        this.vtype = c;
    }

    public int getScore() {
        return this.score;
    }

    public int getPatn() {
        return this.patn;
    }

    public char getType() {
        return this.type;
    }

    public String getStem() {
        return this.stem;
    }

    public char getPos() {
        return this.pos;
    }

    public char getPos2() {
        return this.pos2;
    }

    public char getDinf() {
        return this.dinf;
    }

    public String getNsfx() {
        return this.nsfx;
    }

    public String getJosa() {
        return this.josa;
    }

    public List<String> getJlist() {
        return this.jlist;
    }

    public String getEomi() {
        return this.eomi;
    }

    public List<String> getElist() {
        return this.elist;
    }

    public String getPomi() {
        return this.pomi;
    }

    public String getXverb() {
        return this.xverb;
    }

    public String getVsfx() {
        return this.vsfx;
    }

    public char getVtype() {
        return this.vtype;
    }

    public void addCNoun(CompoundEntry w) {
        this.compound.add(w);
    }

    public List<CompoundEntry> getCNounList() {
        return this.compound;
    }

    public void setCNoun(List cnoun) {
        this.compound = cnoun;
    }

    public void addCNoun(List cnoun) {
        this.compound.addAll(cnoun);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public AnalysisOutput clone() throws CloneNotSupportedException {
        AnalysisOutput output = (AnalysisOutput)super.clone();
        output.setDinf(this.dinf);
        output.setEomi(this.eomi);
        output.setJosa(this.josa);
        output.setNsfx(this.nsfx);
        output.setPatn(this.patn);
        output.setPomi(this.pomi);
        output.setPos(this.pos);
        output.setPos2(this.pos2);
        output.setScore(this.score);
        output.setStem(this.stem);
        output.setType(this.type);
        output.setVsfx(this.vsfx);
        output.setVtype(this.vtype);
        output.setXverb(this.xverb);
        return output;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(MorphUtil.buildTypeString(this.getStem(), this.getPos()));
        if (this.getNsfx() != null) {
            buff.append(",").append(MorphUtil.buildTypeString(this.getNsfx(), 's'));
        }
        if (this.getPatn() != 1 && this.getPatn() != 21) {
            if (this.getPatn() == 2) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
            } else if (this.getPatn() == 3) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getVsfx(), 't'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 4) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getVsfx(), 't'));
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'n'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
            } else if (this.getPatn() == 5) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getVsfx(), 't'));
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'c'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getXverb(), 'W'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 6) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 't'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 11) {
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 12) {
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'n'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
            } else if (this.getPatn() == 13) {
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'n'));
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(1), 's'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 14) {
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'c'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getXverb(), 'W'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.getEomi(), 'e'));
            } else if (this.getPatn() == 15) {
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(1), 'c'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getXverb(), 'W'));
                if (this.getPomi() != null) {
                    buff.append(",").append(MorphUtil.buildTypeString(this.getPomi(), 'f'));
                }
                buff.append(",").append(MorphUtil.buildTypeString(this.elist.get(0), 'n'));
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
            } else if (this.getPatn() == 22) {
                buff.append(",").append(MorphUtil.buildTypeString(this.getJosa(), 'j'));
            }
        }
        return buff.toString();
    }
}

