/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.FileUtil;
import org.apache.lucene.analysis.kr.utils.KoreanEnv;

public class SyllableUtil {
    public static int IDX_JOSA1 = 0;
    public static int IDX_JOSA2 = 1;
    public static int IDX_EOMI1 = 2;
    public static int IDX_EOMI2 = 3;
    public static int IDX_YONG1 = 4;
    public static int IDX_YONG2 = 5;
    public static int IDX_YONG3 = 6;
    public static int IDX_CHEON1 = 7;
    public static int IDX_CHEON2 = 8;
    public static int IDX_CHEON3 = 9;
    public static int IDX_CHEON4 = 10;
    public static int IDX_CHEON5 = 11;
    public static int IDX_BUSA1 = 12;
    public static int IDX_BUSA2 = 13;
    public static int IDX_BUSA3 = 14;
    public static int IDX_BUSA4 = 15;
    public static int IDX_BUSA5 = 16;
    public static int IDX_PRONOUN = 17;
    public static int IDX_EXCLAM = 18;
    public static int IDX_YNPNA = 19;
    public static int IDX_YNPLA = 20;
    public static int IDX_YNPMA = 21;
    public static int IDX_YNPBA = 22;
    public static int IDX_YNPAH = 23;
    public static int IDX_YNPOU = 24;
    public static int IDX_YNPEI = 25;
    public static int IDX_YNPOI = 26;
    public static int IDX_YNPLN = 27;
    public static int IDX_IRRLO = 28;
    public static int IDX_IRRPLE = 29;
    public static int IDX_IRROO = 30;
    public static int IDX_IRROU = 31;
    public static int IDX_IRRDA = 32;
    public static int IDX_IRRBA = 33;
    public static int IDX_IRRSA = 34;
    public static int IDX_IRRHA = 35;
    public static int IDX_PEND = 36;
    public static int IDX_YNPEOMI = 37;
    public static int IDX_WDSURF = 38;
    public static int IDX_EOGAN = 39;
    private static List Syllables;

    public static char[] getFeature(int idx) throws MorphException {
        if (Syllables == null) {
            Syllables = SyllableUtil.getSyllableFeature();
        }
        if (idx < 0) {
            return (char[])Syllables.get(Syllables.size() - 1);
        }
        return (char[])Syllables.get(idx);
    }

    public static char[] getFeature(char syl) throws MorphException {
        int idx = syl - 44032;
        return SyllableUtil.getFeature(idx);
    }

    private static List getSyllableFeature() throws MorphException {
        try {
            Syllables = new ArrayList();
            List line = FileUtil.readLines(KoreanEnv.getInstance().getValue("syllable.dic"), "UTF-8");
            int i = 0;
            while (i < line.size()) {
                if (i != 0) {
                    Syllables.add(((String)line.get(i)).toCharArray());
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new MorphException(e.getMessage());
        }
        return Syllables;
    }

    public static boolean isAlpanumeric(char ch) {
        return ch >= '0' && ch <= 'z';
    }
}

