/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.WSOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSCandidateComparator
implements Comparator<WSOutput> {
    @Override
    public int compare(WSOutput o1, WSOutput o2) {
        int s2;
        int end = o2.getLastEnd() - o1.getLastEnd();
        if (end != 0) {
            return end;
        }
        int s1 = o1.getPhrases().size() == 0 ? 999999999 : o1.getPhrases().size();
        int size = s1 - (s2 = o2.getPhrases().size() == 0 ? 999999999 : o2.getPhrases().size());
        if (size != 0) {
            return size;
        }
        int score = this.calculateScore(o2) - this.calculateScore(o1);
        if (score != 0) {
            return score;
        }
        return 0;
    }

    private int calculateScore(WSOutput o) {
        List<AnalysisOutput> entries = o.getPhrases();
        if (entries.size() == 0) {
            return 0;
        }
        int sum = 0;
        int i = 0;
        while (i < entries.size()) {
            sum += entries.get(i).getScore();
            ++i;
        }
        return sum / entries.size();
    }
}

