% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_graph.R
\name{state_graph}
\alias{state_graph}
\alias{make_node}
\alias{make_edge}
\alias{StateGraph}
\alias{interrupt}
\alias{make_command}
\title{State Graph Framework}
\usage{
make_node(func, name = NULL)

make_edge(from, to, condition = NULL, label = NULL)

StateGraph()

interrupt(value)

make_command(goto = NULL, update = list())
}
\arguments{
\item{func}{A function that takes a `state` list and returns updates.}

\item{name}{An optional name for the node.}

\item{from}{The source node name.}

\item{to}{The destination node name.}

\item{condition}{An optional function that returns a label based on the `state`.}

\item{label}{Optional label for conditional branching.}

\item{value}{A string to print before prompting the user.}

\item{goto}{Name of the next node to transition to.}

\item{update}{A list of key-value updates to the `state`.}
}
\value{
A list containing the function and optional name.

A list representing the edge.

A list of graph methods: \code{add_node}, \code{add_edge},
\code{add_conditional_edges}, \code{set_entry_point}, \code{compile}, \code{END_NODE_NAME}

A character response entered by the user.

A list with `goto` and `update` keys.
}
\description{
A lightweight framework for building state-driven workflows using nodes, edges,
and conditionally branching logic. Each node is a function that takes and mutates a shared `state` list.
}
\section{Functions}{
\itemize{
\item \code{make_node()}: Create a Graph Node

\item \code{make_edge()}: Create a Graph Edge

\item \code{StateGraph()}: Build a State Graph Execution Engine

\item \code{interrupt()}: Pause Execution for User Input

\item \code{make_command()}: Create a Graph Command Result

}}
\section{Functions}{

\describe{
  \item{\code{make_node()}}{Wraps a function in a graph-compatible node.}
  \item{\code{make_edge()}}{Creates a transition between nodes, optionally conditional.}
  \item{\code{StateGraph()}}{Builds and compiles the state graph engine.}
  \item{\code{interrupt()}}{Prompts the user for input during execution.}
  \item{\code{make_command()}}{Signals the next node and state updates.}
}
}

\examples{
graph <- StateGraph()
graph$add_node("start", function(state) list(goto = "end"))
graph$add_node("end", function(state) list())
graph$set_entry_point("start")
agent <- graph$compile()
state <- list()
agent(state)
}
\keyword{graph}
\keyword{llm}
\keyword{state}
\keyword{workflow}
