% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AQSys.R
\name{AQSys}
\alias{AQSys}
\alias{AQSys.default}
\title{Merchuk's Equation to fit Binodal Experimental Data}
\usage{
AQSys(XYdt, ...)

\method{AQSys}{default}(XYdt, mathDesc = "merchuk", ...)
}
\arguments{
\item{XYdt}{- Binodal Experimental data that will be used in the nonlinear fit}

\item{...}{Additional optional arguments. None are used at present.}

\item{mathDesc}{- Character String specifying the nonlinear empirical equation to fit data.
The default method uses Merchuk's equation. Other mathematical descriptors can be listed using AQSysList().}
}
\value{
A list containing three data.frame variables with all data parsed from the worksheet and parameters calculated
through the available mathematical descriptions.
}
\description{
.

Perform a nonlinear regression fit using several mathemmatical descriptors in order to determine the
equation's parameters.
}
\details{
The function returns functions parameters after fitting experimental data to the equations listed in AQSysList().
}
\examples{
#Populating variable XYdt with binodal data
XYdt <- peg4kslt[,1:2]
#Fitting XYdt using Merchuk's function
AQSys(XYdt)
}
\seealso{
\itemize{
\item \code{\link{AQSys.default}}
\item \code{\link{AQSys.plot}}
\item \code{\link{AQSys.tielines}}
\item \code{\link{AQSys.crpt}}
\item \code{\link{AQSysOthmer}}
\item \code{\link{AQSysBancroft}}
}
}

