% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{LMMsolveObject}
\alias{LMMsolveObject}
\title{Fitted LMMsolve Object}
\value{
An object of class \code{LMMsolve} contains the following components:
\item{logL}{The restricted log-likelihood at convergence}
\item{sigma2e}{The residual error}
\item{tau2e}{The estimated variance components}
\item{EDdf}{The effective dimensions}
\item{varPar}{The number of variance parameters for each variance component}
\item{VarDf}{The table with variance components}
\item{theta}{The precision parameters}
\item{coefficients}{The estimated effects from the mixed model equations}
\item{yhat}{The fitted values}
\item{residuals}{The residuals}
\item{nIter}{The number of iterations for the mixed model to converge}
\item{C}{The mixed model coefficient matrix after last iteration}
\item{cholC}{The cholesky decomposition of coefficient matrix C}
\item{constantREML}{The REML constant}
\item{dim}{The dimensions for each of the fixed and random terms in the
mixed model}
\item{term.labels.f}{The names of the fixed terms in the mixed model}
\item{term.labels.r}{The names of the random terms in the mixed model}
\item{splRes}{An object with definition of spline argument}
}
\description{
An object of class \code{LMMsolve} returned by the LMMsolve function,
representing a fitted linear mixed model. Objects of this class have
methods for the generic functions coef, fitted, residuals, loglik and
deviance.
}
