# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

construct_ADchol_Rcpp <- function(obj_spam, P_list) {
    .Call(`_LMMsolver_construct_ADchol_Rcpp`, obj_spam, P_list)
}

#' Calculate the partial derivatives of log-determinant.
#'
#' This function calculates the partial derivatives of the the log-determinant in an
#' efficient way, by using reverse Automated Differentiation of the Cholesky Algorithm,
#' see Smith (1995) for details. Let
#'  \deqn{C = \sum_{i} \theta_i P_i}
#' where the matrices \eqn{P_i} are stored in the `ADchol` object. The partial derivatives
#' of matrix \eqn{C} are defined by:
#' \deqn{\frac{\partial C}{\partial \theta_i} = \text{trace} [C^{-1} P_i]},
#' but are calculated in a more efficient way using backwards Automated Differentiation.
#'
#' @param ADobj object of class ADchol.
#' @param theta a vector with precision or penalty parameters
#'
#' @return The gradient with partial derivatives of \eqn{log|C|} with respect to
#' parameters \eqn{\theta_i}. As attribute \code{logdet}, \eqn{log|C|} is returned.
#'
#' @references
#' Smith, S. P. (1995). Differentiation of the Cholesky algorithm.
#' Journal of Computational and Graphical Statistics, 4(2), 134-147.
#'
#' @noRd
#' @keywords internal
#'
dlogdet <- function(obj, theta, b_ = NULL) {
    .Call(`_LMMsolver_dlogdet`, obj, theta, b_)
}

partialDerivCholesky <- function(obj) {
    .Call(`_LMMsolver_partialDerivCholesky`, obj)
}

diagXCinvXt <- function(obj, transposeX) {
    .Call(`_LMMsolver_diagXCinvXt`, obj, transposeX)
}

GetIntVector <- function(obj, slotName, ArrayIndexing) {
    .Call(`_LMMsolver_GetIntVector`, obj, slotName, ArrayIndexing)
}

RowKron <- function(sX1, sX2) {
    .Call(`_LMMsolver_RowKron`, sX1, sX2)
}

logdet <- function(obj, lambda) {
    .Call(`_LMMsolver_logdet`, obj, lambda)
}

PrintCholesky <- function(obj) {
    .Call(`_LMMsolver_PrintCholesky`, obj)
}

