% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score.lmm}
\alias{score.lmm}
\title{Extract The Score From a Linear Mixed Model}
\usage{
\method{score}{lmm}(
  x,
  effects = "mean",
  data = NULL,
  p = NULL,
  indiv = FALSE,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{effects}{[character] Should the score relative to all coefficients be output (\code{"all"}),
or only coefficients relative to the mean (\code{"mean"} or \code{"fixed"}),
or only coefficients relative to the variance and correlation structure (\code{"variance"} or \code{"correlation"}).}

\item{data}{[data.frame] dataset relative to which the score should be computed. Only relevant if differs from the dataset used to fit the model.}

\item{p}{[numeric vector] value of the model coefficients at which to evaluate the score. Only relevant if differs from the fitted values.}

\item{indiv}{[logical] Should the contribution of each cluster to the score be output? Otherwise output the sum of all clusters of the derivatives.}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{transform.names}{[logical] Should the name of the coefficients be updated to reflect the transformation that has been used?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
When argument indiv is \code{FALSE}, a vector with the value of the score relative to each coefficient.
When argument indiv is \code{TRUE}, a matrix with the value of the score relative to each coefficient (in columns) and each cluster (in rows).
}
\description{
Extract or compute the first derivative of the log-likelihood of a linear mixed model.
}
\details{
For details about the arguments \bold{transform.sigma}, \bold{transform.k}, \bold{transform.rho}, see the documentation of the \link[LMMstar]{coef.lmm} function.
}
\keyword{methods}
