% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProfBoot.R
\name{ProfBoot}
\alias{ProfBoot}
\title{Bootstrap standard errors for the estimators of a lognormal-Pareto mixture}
\usage{
ProfBoot(x, y, minRank, p0, alpha0, mu0, Psi0)
}
\arguments{
\item{x}{list: sequence of integers 1,...,K, where K is the mumber of datasets. Set x = 1 in case
of a single dataset.}

\item{y}{numerical vector: observed sample.}

\item{minRank}{positive integer: minimum possible rank of the threshold.}

\item{p0}{(0<p0<1): starting value of the mixing weight.}

\item{alpha0}{non-negative scalar: starting value of the Pareto shape parameter.}

\item{mu0}{scalar: starting value of the log-expectation of the lognormal distribution on the log scale.}

\item{Psi0}{non-negative scalar: starting value of the log-variance of the lognormal distribution on the log scale.}
}
\value{
Estimated parameters obtained from a bootstrap sample.
}
\description{
This function draws a bootstrap sample and uses it to estimate the parameters of a lognormal-Pareto mixture distribution. Since this is typically called by LPfit, see the help of LPfit for examples.
}
\details{
At each bootstrap replication, the mixture is estimated with thresholds equal to ys(minRank), ys(minRank+1),..., ys(n),
where n is the sample size and ys is the sample in ascending order. The function is typically called by LPfit (see the example below).
}
\references{
Bee, M. (2022), “On discriminating between lognormal and Pareto tail: a mixture-based approach”,
Advances in Data Analysis and Classification, https://doi.org/10.1007/s11634-022-00497-4
}
