% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeChisquared.R
\name{ComputeChisquared}
\alias{ComputeChisquared}
\title{Compute the chi-square scores of features}
\usage{
ComputeChisquared(data, outcome, level, weight = FALSE, ctable = FALSE)
}
\arguments{
\item{data}{A dataset containing an outcome variable and action features with either raw frequencies or weighted frequencies.}

\item{outcome}{Name of the outcome variable.}

\item{level}{The level of outcome. e.g. correct/incorrect would be of 2 levels; 0/1/2 would be 3 levels}

\item{weight}{If weight = TRUE, the weighted frequencies will be computed and then be utilized for the chi-square scores ; If weight = F, returning the chisquare scores computed from the raw feature frequencies.}

\item{ctable}{If ctable = TRUE, returning the contingency tables instead of the chi-square scores.}
}
\value{
This function returns a data frame with ranked chi-scores or contingency tables for each feature.

To get the weighted frequencies solely, please run WeightedFeatures() in LOGAN package.
}
\description{
Compute the chi-square scores of features
}
\examples{
ComputeChisquared(data = cp025q01.wgt[,c(7:13,15)],
outcome = "outcome", level = 2, weight = FALSE, ctable = FALSE)

ComputeChisquared(data = training[,7:14],
outcome = "outcome", level = 2, weight = FALSE, ctable = TRUE)

}
\references{
He Q., von Davier M. (2015) Identifying Feature Sequences from Process Data in Problem-Solving Items with N-Grams. In: van der Ark L., Bolt D., Wang WC., Douglas J., Chow SM. (eds) Quantitative Psychology Research. Springer Proceedings in Mathematics & Statistics, vol 140. Springer, Cham. https://doi-org.ezproxy.uio.no/10.1007/978-3-319-19977-1_13
}
