% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_corr.R
\name{comp.corr}
\alias{comp.corr}
\title{Computing corr}
\usage{
comp.corr(data, time, C)
}
\arguments{
\item{data}{a matrix with rows representing genes and columns representing
different timepoints (NA's added when lags are needed)}

\item{time}{a vector which contains all the timepoints represented in the data}

\item{C}{a numeric value of C used in computing weighted correlation}
}
\value{
a simmilarity matrix with values between -1 and 1
(1 highly correlated, 0 no correlation)
}
\description{
This function computes the correlation upon picking the best lag and
adjusting the data for lags
}
\examples{
comp.corr(array(rnorm(40), c(5, 8)), time = t(array(c(0, 5, 10, 15, 20, 25,
30, 35), c(8, 5))), C = 10)

}
\author{
Thevaa Chandereng, Anthony Gitter
}
