% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_tests.R
\name{gaussian_mu_lr_test}
\alias{gaussian_mu_lr_test}
\title{Test the mean of a gaussian distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
gaussian_mu_lr_test(x, mu = 0, alternative = "two.sided")
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{mu}{a number indicating the tested value of mu.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}
}
\value{
An S3 class containing the test statistic, p value and alternative
hypothesis.
}
\description{
Test the mean of a gaussian distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(100, 0, 1)
gaussian_mu_lr_test(x, 0, "two.sided")

# Null is false
set.seed(1)
x <- rnorm(100, 3, 1)
gaussian_mu_lr_test(x, 0, "greater")
}
