% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_tests.R
\name{negative_binomial_p_lr_test}
\alias{negative_binomial_p_lr_test}
\title{Test p of a negative binomial distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
negative_binomial_p_lr_test(
  num_failures,
  num_success,
  p,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{num_failures}{Number of failures.}

\item{num_success}{Number of successes.}

\item{p}{Hypothesized probability of success.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test p of a negative binomial distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true. 48 failures before 52 successes.
negative_binomial_p_lr_test(48, 52, .50, "two.sided")

# Null is false. 25 failures before 75 successes.
negative_binomial_p_lr_test(25, 75, .50, "two.sided")
}
