% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_mu_tests.R
\name{empirical_mu_one_sample}
\alias{empirical_mu_one_sample}
\title{Test the mean parameter of an unknown distribution.}
\source{
\itemize{
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Owen. Empirical Likelihood. Chapman & Hall/CRC.
}
}
\usage{
empirical_mu_one_sample(x, mu, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector.}

\item{mu}{a number indicating the tested value of mu.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the mean parameter of an unknown distribution.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(25, 0, 1)
empirical_mu_one_sample(x, 0, "two.sided")

# Null is false
set.seed(1)
x <- rnorm(25, 2, 1)
empirical_mu_one_sample(x, 1, "greater")
}
