% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST.R
\name{E_VandeGriend}
\alias{E_VandeGriend}
\title{Land Surface Emissivity according to Van de Griend and Owe 1993}
\usage{
E_VandeGriend(NDVI)
}
\arguments{
\item{NDVI}{Raster* object, NDVI calculated from remote sensing imagery}
}
\value{
RasterLayer
}
\description{
This function calculates Land Surface Emissivity according to Van de Griend and Owe 1993
}
\examples{
NDVI <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_VandeGriend(NDVI)
}
