% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTFH_Gibbs_based.R
\name{estimate_gen_liability_ltfh}
\alias{estimate_gen_liability_ltfh}
\title{Estimate genetic liability similar to LT-FH}
\usage{
estimate_gen_liability_ltfh(
  h2,
  phen,
  child_threshold,
  parent_threshold,
  status_col_offspring = "CHILD_STATUS",
  status_col_father = "P1_STATUS",
  status_col_mother = "P2_STATUS",
  status_col_siblings = "SIB_STATUS",
  number_of_siblings_col = "NUM_SIBS",
  tol = 0.01
)
}
\arguments{
\item{h2}{Liability scale heritability of the trait being analysed.}

\item{phen}{tibble or data.frame with status of the genotyped individual, parents and siblings.}

\item{child_threshold}{single numeric value that is used as threshold for the offspring and siblings.}

\item{parent_threshold}{single numeric value that is used as threshold for both parents}

\item{status_col_offspring}{Column name of status for the offspring}

\item{status_col_father}{Column name of status for the father}

\item{status_col_mother}{Column name of status for the mother}

\item{status_col_siblings}{Column name of status for the siblings}

\item{number_of_siblings_col}{Column name for the number of siblings for a given individual}

\item{tol}{Convergence criteria of the Gibbs sampler. Default is 0.01, meaning a standard error of the mean below 0.01}
}
\value{
Returns the estimated genetic liabilities.
}
\description{
Estimate genetic liability similar to LT-FH
}
\examples{
phen <- data.frame(
CHILD_STATUS = c(0,0),
P1_STATUS = c(1,1),
P2_STATUS = c(0,1),
SIB_STATUS = c(1,0),
NUM_SIBS = c(2,0))

h2 <- 0.5
child_threshold <- 0.7
parent_threshold <- 0.8

estimate_gen_liability_ltfh(h2, phen, child_threshold, parent_threshold)

}
