% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_matrix_functions.R
\name{graph_based_covariance_construction_multi}
\alias{graph_based_covariance_construction_multi}
\title{Constructing covariance matrix from local family graph for multi trait analysis}
\usage{
graph_based_covariance_construction_multi(
  fam_id,
  pid,
  cur_proband_id,
  cur_family_graph,
  h2_vec,
  genetic_corrmat,
  phen_names,
  add_ind = TRUE
)
}
\arguments{
\item{fam_id}{Name of column with the family ID}

\item{pid}{Name of column of personal ID}

\item{cur_proband_id}{id of proband}

\item{cur_family_graph}{local graph of current proband}

\item{h2_vec}{vector of liability scale heritabilities}

\item{genetic_corrmat}{matrix with genetic correlations between considered phenotypes. Must have same order as h2_vec.}

\item{phen_names}{Names of the phenotypes, as given in cur_family_graph.}

\item{add_ind}{whether to add genetic liability of the proband or not. Defaults to true.}
}
\value{
list with three elements. The first element is temp_tbl, which contains the id of
the current proband, the family ID and the lower and upper thresholds for all phenotypes. The second element,
cov, is the covariance matrix of the local graph centred on the current proband. The third element is newOrder,
which is the order of ids from pid and phen_names pasted together, such that order can be enforced elsewhere too.
}
\description{
Function that constructs the genetic covariance matrix given a graph around a proband
and extracts the threshold information from the graph.
}
\examples{
fam <- data.frame(
fam = c(1, 1, 1,1),
id = c("pid", "mom", "dad", "pgf"),
dadcol = c("dad", 0, "pgf", 0),
momcol = c("mom", 0, 0, 0))

thresholds <- data.frame(
  id = c("pid", "mom", "dad", "pgf"),
  lower_1 = c(-Inf, -Inf, 0.8, 0.7),
  upper_1 = c(0.8, 0.8, 0.8, 0.7),
  lower_2 = c(-Inf, 0.3, -Inf, 0.2),
  upper_2 = c(0.3, 0.3, 0.3, 0.2))

graph <- prepare_graph(fam, icol = "id", fcol = "dadcol", mcol = "momcol",
 node_attributes = thresholds)

ntrait <- 2
genetic_corrmat <- matrix(0.2, ncol = ntrait, nrow = ntrait)
diag(genetic_corrmat) <- 1
full_corrmat <- matrix(0.3, ncol = ntrait, nrow = ntrait)
diag(full_corrmat) <- 1
h2_vec <- rep(0.6, ntrait)

graph_based_covariance_construction_multi(fam_id = "fam",
                                          pid = "id",
                                          cur_proband_id = "pid",
                                          cur_family_graph = graph,
                                          h2_vec = h2_vec,
                                          genetic_corrmat = genetic_corrmat,
                                          phen_names = c("1", "2"))

}
