% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettylog.R
\name{prettylog}
\alias{prettylog}
\title{Pretty Breakpoints on Log Scale}
\usage{
prettylog(x, lead = c(1, 5), extra = 5)
}
\arguments{
\item{x}{A numeric vector.}

\item{lead}{An integer vector giving the desired lead digits of pretty values on
the log scale, default c(1, 5).}

\item{extra}{An integer scalar giving the desired number of additional
non-log scale values to include, default 5.}
}
\value{
A numeric vector of pretty values covering the range of \code{x} on
  the log scale.
}
\description{
Compute a sequence of "round" values which cover the range of \code{x} on
the log scale.
}
\examples{
vals <- rlnorm(100, 6)
summary(vals)
prettylog(vals, 1, 0)
prettylog(vals, 1)
prettylog(vals, c(1, 2, 5))
}
