% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedotransfer_functions.R
\name{ptfs}
\alias{ptfs}
\alias{hydpar_puh2}
\alias{hydpar_hypres}
\alias{hydpar_hypres_tab}
\alias{hydpar_wessolek_tab}
\alias{hydpar_ff_b90}
\title{Functions to derive soil hydraulic properties from soil properties}
\usage{
hydpar_puh2(clay, silt, sand, bd, oc.pct = 0.5)

hydpar_hypres(clay, silt, bd, oc.pct = 0.1, topsoil = TRUE, humconv = 1.72)

hydpar_hypres_tab(texture, topsoil)

hydpar_wessolek_tab(texture)

hydpar_ff_b90(n = 1)
}
\arguments{
\item{clay, silt, sand}{Numeric vectors of clay, silt, sand in mass \%.
Particle size ranges for clay, silt and sand correspond to <2, 2-63, and
63-2000 \eqn{\mu m}{\mum}. For \code{\link{hydpar_hypres}}, the particle
size limit between silt and sand should be 50 \eqn{\mu m}{\mum}.}

\item{bd}{Numeric vector of bulk density in g cm-3.}

\item{oc.pct}{Numeric vector of organic carbon content in mass \%.}

\item{topsoil}{Logical: Is the sample from the topsoil? Used in
\code{\link{hydpar_hypres_tab}}.}

\item{humconv}{Conversion factor from oc.pct to organic matter percent.
Default: 1.72. Only for \code{hydpar_hypres_tab}.}

\item{texture}{Character vector of soil texture classes. For
\code{hydpar_wessolek_tab} classes according to KA5 (AG Boden 2005) have to
be provided. When using \code{\link{hydpar_hypres_tab}}, texture classes
according to FAO (1990) have to provided.}

\item{n}{An integer value specifying the number of rows of the returned
data.frame (i.e. the number of repetitions of the MvG-Parameter set, only
for \code{hydpar_ff_hamken}).}
}
\value{
A data.frame with the following variables: \describe{
  \item{ths}{Saturation water content fraction} \item{thr}{Residual water
  content fraction} \item{npar}{N parameter of the van Genuchten water
  retention function} \item{mpar}{M parameter of the van Genuchten water
  retention function} \item{alpha}{Alpha parameter of the van Genuchten water
  retention function (1/m)} \item{ksat}{Saturated hyraulic conductivity
  parameter of Mualem hydraulic conductivity function (mm/d)}
  \item{tort}{Tortuosity parameter of Mualem hydraulic conductivity function}
  }
}
\description{
A set of pedotransfer functions for deriving Mualem - van Genuchten
parameters from soil physical properties of soil horizons, such as soil
texture, bulk density and carbon content.
}
\details{
Function \code{hydpar_puh2} derives Mualem - van Genuchten (MvG) parameters
using the regression functions developed by Puhlmann & von Wilpert (2011).
The equations of Wösten et al. (1999) are available via \code{hydpar_hypres},
and their tabulated values for soil texture classes can be derived using the
function \code{hydpar_hypres_tab}. The table of MvG parameters from Wesselok
et al. (2009; Tab. 10) is accessible by \code{hydpar_wessolek_tab}. For this
function, soil texture classes after the German texture classification system
(KA5, AG Boden 2005) have to be provided. To derive hydraulic parameters of
forest floor horizons, the function \code{hydpar_ff_b90} can be used. It
returns the single MvG parameter set for forest floor horizons reported by
Hammel & Kennel (2001) in their original LWF-Brook90 publication.
}
\examples{

hydpar_puh2(clay = c(10,20), silt = c(40,20), sand = c(50,60), bd = c(1.6, 1.4))

hydpar_hypres(20,20,1.5,2)

hydpar_hypres_tab(texture = c("C","MF"), topsoil = c(TRUE,FALSE))

hydpar_wessolek_tab(c("Us", "Ls2", "mSfS"))

hydpar_ff_b90(n = 5)
}
\references{
AG Boden (2005)
Bodenkundliche Kartieranleitung
Schweizerbart'sche Verlagsbuchhandlung, Stuttgart

Food and Agriculture Organisation (FAO) (1990)
Guidelines for soil description
FAO/ISRIC, Rome, 3rd edition

Hammel K & Kennel M (2001)
Charakterisierung und Analyse der Wasserverfügbarkeit und des Wasserhaushalts
von Waldstandorten in Bayern mit dem Simulationsmodell BROOK90.
\emph{Forstliche Forschungsberichte München} 185

Puhlmann H, von Wilpert K (2011)
Testing and development of pedotransfer functions for water retention and
hydraulic conductivity of forest soils.
\emph{Waldökologie, Landschaftsforschung und Naturschutz} 12, pp. 61-71

Wessolek G, Kaupenjohann M and Renger H (2009)
Bodenphysikalische Kennwerte und Berechnungsverfahren für die Praxis.
\emph{Bodenökologie und Bodengenese} 40, Berlin, Germany

Woesten JHM, Lilly A, Nemes A, Le Bas C  (1999)
Development and use of a database of hydraulic properties of European soils.
\emph{Geoderma} 90, pp. 169-185
}
