% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpm_functions.R
\name{generator}
\alias{generator}
\title{Build the generator matrix of a continuous-time Markov chain}
\usage{
generator(param, byrow = FALSE, report = TRUE)
}
\arguments{
\item{param}{unconstrained parameter vector of length N*(N-1) where N is the number of states of the Markov chain}

\item{byrow}{logical indicating if the transition probability matrix should be filled by row}

\item{report}{logical, indicating whether the generator matrix Q should be reported from the fitted model. Defaults to \code{TRUE}, but only works if when automatic differentiation with \code{RTMB} is used.}
}
\value{
infinitesimal generator matrix of dimension c(N,N)
}
\description{
This function builds the \strong{infinitesimal generator matrix} for a \strong{continuous-time Markov chain} from an unconstrained parameter vector.
}
\examples{
# 2 states: 2 free off-diagonal elements
generator(rep(-1, 2))
# 3 states: 6 free off-diagonal elements
generator(rep(-2, 6))
}
\seealso{
Other transition probability matrix functions: 
\code{\link{tpm}()},
\code{\link{tpm_cont}()},
\code{\link{tpm_emb}()},
\code{\link{tpm_emb_g}()},
\code{\link{tpm_g}()},
\code{\link{tpm_p}()}
}
\concept{transition probability matrix functions}
