% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test_simulate.R
\name{chisq.test.simulate}
\alias{chisq.test.simulate}
\title{Simulate Chi-squared tests with conditioning}
\usage{
chisq.test.simulate(x, conditioning = "total", x0 = NULL, B = 10000)
}
\arguments{
\item{x}{matrix with the contingency table}

\item{conditioning}{character string specifying the simulation scenario. Defaults to \code{"total"}. Other possible scenarios are \code{"row"}, \code{"col"}, and \code{"both"}.}

\item{x0}{matrix specifying the null distribution. Defaults to \code{NULL}, in which case the null is estimated from the observed data \code{x}.}

\item{B}{integer specifying the number of replicates used in the Monte Carlo test. Defaults to 10000.}
}
\value{
An object of class \code{"htest"}.
}
\description{
\code{chisq.test.simulate} simulates the chi-squared test for a 2-way contingency tabel.
}
\details{
Using \code{conditioning="both"} corresponds to selecting \code{simulate.p.value=TRUE} in \code{\link{chisq.test}}. However, conditioning on both row and column marginals appears to be rarely justified in real data. Instead \code{conditioning="total"} is the correct choice for testing independence. Similarly, \code{conditioning="row"} is recommended when the row marginals e.g. are fixed by experimental design.
The option \code{x0} has no effect when conditioning on both row and column marginals.
}
\note{
The code has not been optimized for speed, and might be slow.
}
\examples{
# The Avadex dataset
Xobs <- matrix(c(2,3,6,40),2,2)
rownames(Xobs) <- c("Avadex +","Avadex -")
colnames(Xobs) <- c("Tumor +","Tumor -")

# In this example only the rows appear to be fixed by experimental design.
# As is seen below, conditioning also on the columns is misleading conservative.
chisq.test.simulate(Xobs,"both")
chisq.test.simulate(Xobs,"row")
chisq.test.simulate(Xobs,"total")

# Conditioning both on row and column marginals is simular to chisq.test().
chisq.test(Xobs,simulate.p.value=TRUE)

}
\seealso{
\code{\link{chisq.test}}
}
\author{
Bo Markussen
}
\keyword{htest}
