% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladreg.R
\name{ladreg}
\alias{ladreg}
\title{Fitting LAD Models}
\usage{
ladreg(y, X, intercept = 1, alpha = 0.05, print = 1)
}
\arguments{
\item{y}{A vector with response variables.}

\item{X}{A matrix or vector with explanatory variables.}

\item{intercept}{1 for a model with intercept and 0 for a model without intercept.}

\item{alpha}{significance level to hypotheses tests.}

\item{print}{1 to print response variables, fitted values and residuals, 0 to don't print.}
}
\value{
\item{outliers     }{          A vector with outliers indices.}.
}
\description{
Fitting LAD Models
}
\examples{
### Using stackloss data

ladreg(stack.loss, stack.x, intercept =1, alpha=0.05, print=1)
}
\references{
Dielman, T. E. (2005) Least absolute value regression: recent contributions.
\emph{Journal of Statistical Computational and Simulation}, \strong{75}(4), 263–286. \doi{10.1080/0094965042000223680}
}
