% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/delta_01.R
\name{delta_01}
\alias{delta_01}
\title{Input parameters to get a zero mean, unit variance output for a given delta}
\usage{
delta_01(delta, mu.y = 0, sigma.y = 1, distname = "normal")
}
\arguments{
\item{delta}{scalar; heavy-tail parameter.}

\item{mu.y}{output mean; default: \code{0}.}

\item{sigma.y}{output standard deviation; default: \code{1}.}

\item{distname}{string; distribution name.  Currently this function only supports
\code{"normal"}.}
}
\value{
5-dimensional vector (\eqn{\mu_x(\delta)}, \eqn{\sigma_x(\delta)}, 0, \eqn{\delta}, 1),
where \eqn{\gamma = 0}  and \eqn{\alpha = 1} are set for the sake of compatiblity with other functions.
}
\description{
Given \eqn{\delta}, this function computes the input mean
\eqn{\mu_x(\delta)} and standard deviation \eqn{\sigma_x(\delta)} for
Gaussian input \eqn{X \sim N(\mu_x(\delta), \sigma_x^2(\delta))}, such that
the resulting heavy-tail Lambert W Gaussian RV \eqn{Y} has zero mean and
unit variance.

The function works for any output mean and standard deviation, but default values are
\eqn{\mu_y = 0} and \eqn{\sigma_y = 1} since they are the most useful, e.g.,
to generate a standardized Lambert W white noise sequence.

So far only for Gaussian input and scalar \eqn{\delta}.
}
\examples{
delta_01(0)	# for delta = 0, input == output, therefore (0,1,0,0,1)
# delta > 0 (heavy-tails):
#   since Y is symmetric for all delta:
#   mean = 0; however, sd must be smaller now
delta_01(0.1)
delta_01(1/3) # only moments up to order 2 exist
delta_01(1) # neither mean nor variance exist, thus NA
}
\keyword{math}
\keyword{univar}

