% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_Taylor.R
\name{delta_Taylor}
\alias{delta_Taylor}
\title{Estimate of delta by Taylor approximation}
\usage{
delta_Taylor(y, kurtosis.y = kurtosis(y), distname = "normal")
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{kurtosis.y}{kurtosis of \eqn{y}; default: empirical kurtosis of data \code{y}.}

\item{distname}{string; name of the distribution. Currently only supports \code{"normal"}.}
}
\value{
scalar; estimated \eqn{\delta}.
}
\description{
Computes an initial estimate of \eqn{\delta} based on the Taylor
approximation of the kurtosis of Lambert W \eqn{\times} Gaussian RVs. See
Details for the formula.

This is the initial estimate for \code{\link{IGMM}} and \code{\link{delta_GMM}}.
}
\details{
The second order Taylor approximation of the theoretical kurtosis of a
heavy tail Lambert W x Gaussian RV around \eqn{\delta = 0} 
equals

\deqn{ \gamma_2(\delta) = 3 + 12 \delta + 66 \delta^2 + \mathcal{O}(\delta^3). }

Ignoring higher order terms, using the empirical estimate on the left hand side, and 
solving for \eqn{\delta} yields (positive root) 
\deqn{\widehat{\delta}_{Taylor} = \frac{1}{66} \cdot \left( \sqrt{66
\widehat{\gamma}_2(\mathbf{y}) - 162}-6 \right), } 
where \eqn{\widehat{\gamma}_2(\mathbf{y})} is the empirical kurtosis of \eqn{\mathbf{y}}.

Since the kurtosis is finite only for \eqn{\delta < 1/4},
\code{delta_Taylor} upper-bounds the returned estimate by \eqn{0.25}.
}
\examples{

set.seed(2)
# a little heavy-tailed (kurtosis does exist)
y <- rLambertW(n = 1000, theta = list(beta = c(0, 1), delta = 0.2), 
               distname = "normal")
# good initial estimate since true delta=0.2 close to 0, and
# empirical kurtosis well-defined.
delta_Taylor(y) 
delta_GMM(y) # iterative estimate

y <- rLambertW(n = 1000, theta = list(beta = c(0, 1), delta = 1), 
               distname = "normal") # very heavy-tailed (like a Cauchy)
delta_Taylor(y) # bounded by 1/4 (as otherwise kurtosis does not exist)
delta_GMM(y) # iterative estimate

}
\seealso{
\code{\link{IGMM}}  to estimate all parameters jointly.
}
\keyword{optimize}

