% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadpoints.R
\name{quadpoints}
\alias{quadpoints}
\title{Quadrature points}
\usage{
quadpoints(dim, quad_tech = "Gaussian", quad_points = NULL)
}
\arguments{
\item{dim}{Dimension of the quadrature}

\item{quad_tech}{A string with technique. "Gaussian" for Gaussian quadrature. 
or "QMCEM" for Quasi-Monte Carlo quadrature.}

\item{quad_points}{Amount of quadrature points. If quadratura_technique is "Gaussian". 
It can be NULL, in Quasi-Monte Carlo it is 2000 by default.}
}
\description{
Return a list with quadrature points according dimensionality, technique
and number of points.
}
\examples{
\dontrun{qp = quadpoints(dim = 4,quad_tech = "QMCEM",quad_points = 3000)}
}

