% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{envelope_itemf}
\alias{envelope_itemf}
\title{Confidence Envelops for an item}
\usage{
envelope_itemf(item, numboot = 100, alpha = 0.05, item.fit, data,
  seed = 5000L)
}
\arguments{
\item{item}{a number indicating the item to be evaluated.}

\item{numboot}{number of iterations bootstrap, used to plot the envelopes. By default 100.}

\item{alpha}{level of significance to plot the envelopes. By default 0.05.}

\item{item.fit}{object LatentREGpp::itemfit() type.}

\item{data}{a dataframe or a matrix with the test data.}

\item{seed}{the seed to fix the random sample. By default 500L.}
}
\value{
plot with the envelopes and the caracteristic curve of the item.
}
\description{
Graphs confidence bands of an item, to evaluate 
the goodness of fit of the model.
}
\references{
David Thissen, Howard Wainer  D. (1990). Confidence Envelopes for Item Response Theory. \emph{Journal of Educational Statistics, Vol 15, No 2}, 113-128.
}
\seealso{
\code{\link{orlando_itemf}}, \code{\link{z3_itemf}}
}

