% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfit.R
\name{itemfit}
\alias{itemfit}
\title{Parameter estimation of a test}
\usage{
itemfit(data, dim, model = "2PL", EMepsilon = 1e-04, clusters = NULL,
  quad_tech = NULL, quad_points = NULL,
  individual_weights = as.numeric(c()), initial_values = NULL, SD = FALSE,
  verbose = TRUE, save_time = TRUE)
}
\arguments{
\item{data}{The matrix containing the answers of tested individuals}

\item{dim}{The dimensionality of the test}

\item{model}{"1PL", "2PL" or "3PL"}

\item{EMepsilon}{Convergence value to determine the accuracy of the test}

\item{clusters}{A vector with cluster per dimension}

\item{quad_tech}{A string with technique. "Gaussian" for Gaussian quadrature 
or "QMCEM" for Quasi-Monte Carlo quadrature}

\item{quad_points}{Amount of quadrature points. If quadratura_technique is "Gaussian". It can be NULL}

\item{individual_weights}{A vector with Weights of the quadrature points.}

\item{initial_values}{A matrix with initial values for estimation process. Be sure about
dimension, model and consistency with data.}

\item{SD}{calculate for standar desviation for items}

\item{verbose}{True for get information about estimation process in runtime. False in otherwise.}

\item{save_time}{True for save estimation time. False otherwise.}
}
\description{
Estimates the test parameters according to the Multidimensional Item Response Theory
}
\section{Models}{


LatentREGpp has different models to fit likelihood value according parameters to estimate.

\describe{
  \item{3PL}{
    General. Probability is given by
    \deqn{P_{ij} = c_j + \frac{1 - c_j}{1 + exp(-\eta_{ij})}}
    Where \emph{i} references individual and \emph{j} references the item; c is 
    a value for guessing parameter between 0 and 1. i index is referenced by number of
    examinees or individuals and j index is referenced by items in test.
    \eqn{\eta} is \deqn{\eta_{ij} = \strong{\emph{a}}^{t}_j\theta_i+d_j}
    In unidimensional an \emph{a} is scalar, in
    multidimensional an \strong{\emph{a}} is vector.
    For 1PL model \emph{a} has value 1
  }
  \item{2PL}{
    c = 0
  }
  \item{1PL}{
    c = 0
    \strong{\emph{a}} vector has a value 1 for each element 
  }
}
}
\examples{
\dontrun{
#Example 1

dir = normalizePath(system.file(package="LatentREGpp"),winslash = "/")
folder = "/dataset/1D/dicho/"
file = "1000x50-1.csv"
data_dir = paste(c(dir, folder, file), collapse = "")
data = read.table(file = data_dir, sep = ";")
est <- itemfit(data = data, dim = 1)

#Example 2

#Dichotomous and multidimensional data
dir = normalizePath(system.file(package="LatentREGpp"),winslash = "/")
folder = "/dataset/3D/dicho/"
file = "1000x55-1.csv"
data_dir = paste(c(dir, folder, file), collapse = "")
data = read.table(file = data_dir, sep = ";")
clust <- c(20,20,15)
st <- itemfit(data = data, model = "2PL",dim = 3, 
       EMepsilon = 1e-03, clusters = clust, quad_tech = "Gaussian")
}
}

