% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impedance_summary.R
\name{impedance_summary}
\alias{impedance_summary}
\title{Extract and summarize Impedance data if available}
\usage{
impedance_summary(dataset = NULL)
}
\arguments{
\item{dataset}{A JSON object/list loaded into the work environment. If NULL, attempts to load the default dataset from the LeadSense package.}
}
\value{
A list containing:
\itemize{
\item \code{combined_impedance_df} - The full impedance dataset (if available).
\item \code{impedance_summary} - Summary of mean impedance values by Hemisphere and Type.
}
If no valid impedance data is found, a message is printed instead.
}
\description{
This function extracts impedance data from a JSON-like dataset and computes summary statistics.
}
\examples{
impedance_results <- impedance_summary(dataset)
print(impedance_results$impedance_summary)
print(impedance_results$combined_impedance_df)
}
