% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReflectedPolygon.R
\name{ReflectedPolygon}
\alias{ReflectedPolygon}
\title{Creates the reflection about a line of a given polygon}
\usage{
ReflectedPolygon(Poly, Line)
}
\arguments{
\item{Poly}{Polygon object, previously created with function \code{CreatePolygon}}

\item{Line}{Line object previously created with \code{CreateLinePoints} or \code{CreateLineAngle}, to be used as the axis of symmetry}
}
\value{
Returns the reflection of a polygon about a line
}
\description{
\code{ReflectedPolygon} creates the reflection about a line of a given polygon
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, "blue")
P1 <- c(-3,2)
P2 <- c(1,-4)
Line <- CreateLinePoints(P1, P2)
Draw(Line, "black")
Poly_reflected <- ReflectedPolygon(Poly, Line)
Draw(Poly_reflected, "orange")
}
