% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_classify}
\alias{opf_classify}
\title{Executes the test phase of the OPF classifier}
\usage{
opf_classify(dataSet, classifier, precomputedDistance = NA)
}
\arguments{
\item{dataSet}{The testing data object produced by the opf_split function (subGraph object)}

\item{classifier}{The classifier object produced by one of the classification functions (model object)}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns the given subGraph classification list (predicted labels)
}
\description{
Executes the test phase of the OPF classifier
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.5,0,0.5,0)
T <- X$training
T2 <- X$testing
Y <- opf_train(T)
class <- opf_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
