% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_interdaily_stability.R
\name{interdaily_stability}
\alias{interdaily_stability}
\title{Interdaily stability (IS)}
\usage{
interdaily_stability(
  Light.vector,
  Datetime.vector,
  use.samplevar = FALSE,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Datetime.vector}{Vector containing the time data. Must be POSIXct.}

\item{use.samplevar}{Logical. Should the sample variance be used (divide by N-1)?
By default (\code{FALSE}), the population variance (divide by N) is used, as described
in Van Someren et al. (1999).}

\item{na.rm}{Logical. Should missing values be removed? Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should the output be returned as a data frame? If \code{TRUE}, a data
frame with a single column named \code{interdaily_stability} will be returned.
Defaults to \code{FALSE}.}
}
\value{
Numeric value or dataframe with column 'IS'.
}
\description{
This function calculates the variability of 24h light exposure patterns across
multiple days. Calculated as the ratio of the variance of the average daily
pattern to the total variance across all days. Calculated with mean hourly
light levels. Ranges between 0 (Gaussian noise) and 1 (Perfect Stability).
}
\details{
Note that this metric will always be 1 if the data contains only one 24 h day.
}
\examples{
set.seed(1)
N <- 24 * 7
# Calculate metric for seven 24 h days with two measurements per hour
dataset1 <-
  tibble::tibble(
    Id = rep("A", N * 2),
    Datetime = lubridate::as_datetime(0) + c(lubridate::minutes(seq(0, N * 60 - 30, 30))),
    MEDI = sample(1:1000, N * 2)
  )
dataset1 \%>\%
  dplyr::summarise(
    "Interdaily stability" = interdaily_stability(MEDI, Datetime)
  )
}
\references{
Van Someren, E. J. W., Swaab, D. F., Colenda, C. C., Cohen, W.,
McCall, W. V., & Rosenquist, P. B. (1999). Bright Light Therapy: Improved
Sensitivity to Its Effects on Rest-Activity Rhythms in Alzheimer Patients
by Application of Nonparametric Methods. \emph{Chronobiology International},
16(4), 505–518. \doi{10.3109/07420529908998724}

Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
