% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_period_above_threshold.R
\name{period_above_threshold}
\alias{period_above_threshold}
\title{Length of longest continuous period above/below threshold}
\usage{
period_above_threshold(
  Light.vector,
  Time.vector,
  comparison = c("above", "below"),
  threshold,
  epoch = "dominant.epoch",
  loop = FALSE,
  na.replace = FALSE,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct},
\link[hms]{hms}, \link[lubridate]{duration}, or \link[base]{difftime}.}

\item{comparison}{String specifying whether the period of light levels above or
below threshold should be calculated. Can be either \code{"above"} (the default)
or \code{"below"}. If two values are provided for \code{threshold}, this argument will be ignored.}

\item{threshold}{Single numeric value or two numeric values specifying the
threshold light level(s) to compare with. If a vector with two values is provided,
the period of light levels within the two thresholds will be calculated.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{loop}{Logical. Should the data be looped? Defaults to \code{FALSE}.}

\item{na.replace}{Logical. Should missing values (NA) be replaced
for the calculation? If \code{TRUE} missing values will not be removed but will
result in \code{FALSE} when comparing \code{Light.vector} with \code{threshold}.
Defaults to \code{FALSE}.}

\item{na.rm}{Logical. Should missing values (NA) be removed for the calculation?
If \code{TRUE}, this argument will override \code{na.replace}. Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should a data frame be returned? If \code{TRUE}, a data
frame with a single column named \verb{period_\{comparison\}_\{threshold\}} will be returned.
Defaults to \code{FALSE}.}
}
\value{
A duration object (see \code{\link[lubridate]{duration}}) as single value,
or single column data frame.
}
\description{
This function finds the length of the longest continous period above/below
a specified threshold light level or within a specified range of light levels.
}
\examples{

N <- 60
# Dataset with continous period of >250lx for 35min
dataset1 <-
  tibble::tibble(
    Id = rep("A", N),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(1:N),
    MEDI = c(sample(1:249, N-35, replace = TRUE), 
             sample(250:1000, 35, replace = TRUE))
  )

dataset1 \%>\%
  dplyr::reframe("Period >250lx" = period_above_threshold(MEDI, Datetime, threshold = 250))

dataset1 \%>\%
  dplyr::reframe("Period <250lx" = period_above_threshold(MEDI, Datetime, "below", threshold = 250))

# Dataset with continous period of 100-250lx for 20min
dataset2 <-
  tibble::tibble(
    Id = rep("B", N),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(1:N),
    MEDI = c(sample(c(1:99, 251-1000), N-20, replace = TRUE), 
             sample(100:250, 20, replace = TRUE)),
  )
dataset2 \%>\%
  dplyr::reframe("Period 250lx" = period_above_threshold(MEDI, Datetime, threshold = c(100,250)))

# Return data frame
dataset1 \%>\%
  dplyr::reframe(period_above_threshold(MEDI, Datetime, threshold = 250, as.df = TRUE))

}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
