% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{sample.data.irregular}
\alias{sample.data.irregular}
\title{Sample of highly irregular wearable data}
\format{
\code{sample.data.irregular} A tibble with 11,422 rows and 13 columns:
\describe{
\item{Id}{A \code{character} vector indicating the participant (only \code{P1}).}
\item{Datetime}{POSIXct Datetime}
\item{lux}{numeric Illuminance. Unit is lux.}
\item{kelvin}{numeric correlated colour temperature (CCT). Unit is Kelvin.}
\item{rgbR}{numeric red sensor channel output. Unit is W/m2/nm.}
\item{rgbG}{numeric green sensor channel output. Unit is W/m2/nm.}
\item{rgbB}{numeric blue sensor channel output. Unit is W/m2/nm.}
\item{rgbIR}{numeric infrared sensor channel output. Unit is W/m2/nm.}
\item{movement}{numeric indicator for movement (intensity) of the device. Movement is given in discrete counts correlating to the number of instances the accelerometer records instances greater than 0.1875g per 15s sampling interval.}
\item{MEDI}{melanopic EDI measurement data. Unit is lux.}
\item{R.}{Unknown, but likely direct or derived output from the red sensor channel}
\item{G.}{Unknown, but likely direct or derived output from the green sensor channel}
\item{B.}{Unknown, but likely direct or derived output from the blue sensor channel}
}
}
\usage{
sample.data.irregular
}
\description{
A dataset collected with a wearable device that has a somewhat irregular
recording pattern. Overall, the data are recorded every 15 seconds. Every
tenth or so measurement takes 16 seconds, every hundredths 17 seconds, every
thousandths 18 seconds, and so on. This makes the dataset a prime example for
handling and dealing with irregular data.
}
\keyword{datasets}
