% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NWLindley.R
\name{NWLindley}
\alias{NWLindley}
\alias{dnwlindley}
\alias{hnwlindley}
\alias{pnwlindley}
\alias{qnwlindley}
\alias{rnwlindley}
\title{New Weighted Lindley Distribution}
\source{
[d-h-p-q-r]nwlindley are calculated directly from the definitions. \code{rnwlindley} uses the quantile function.
}
\usage{
dnwlindley(x, theta, alpha, log = FALSE)

pnwlindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qnwlindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE, L = 1e-04,
  U = 50)

rnwlindley(n, theta, alpha, L = 1e-04, U = 50)

hnwlindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{L, U}{interval which \code{uniroot} searches for a root (quantile), L = 1e-4 and U = 50 are the default values.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dnwlindley} gives the density, \code{pnwlindley} gives the distribution function, \code{qnwlindley} gives the quantile function, \code{rnwlindley} generates random deviates and \code{hnwlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the new weighted Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta,\alpha )={\frac{{\theta }^{2}\left( 1+\alpha \right) ^{2}}{\alpha \left( \alpha \theta +\alpha +\theta +2\right) }}\left( 1+x\right) \left( 1-e{^{-\theta \alpha x}}\right) e{^{-\theta x}}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha )=1-{\frac{\left( 1+\alpha \right) ^{2}\left( \theta x+\theta +1\right) e{^{-\theta x}}}{\alpha \left( \alpha \theta +\alpha +\theta +2\right) }}+{\frac{\left( \theta \alpha x+\alpha \theta +\theta x+\theta +1\right) e{^{-\theta x}}e{^{-\theta \alpha x}}}{\alpha \left(\alpha \theta +\alpha +\theta +2\right) }}}%

Quantile function
\deqn{\code{does not have a closed mathematical expression}}

Hazard rate function
\deqn{h(x\mid \theta,\alpha )=\frac{{\theta }^{2}\left( 1+\alpha \right) ^{2}\left( 1+x\right) \left( 1-e{^{-\theta \alpha x}}\right) e{^{-\theta x}}}{\left( 1+\alpha \right) ^{2}\left( \theta x+\theta +1\right) e{^{-\theta x}-}\left( \theta \alpha x+\alpha \theta +\theta x+\theta +1\right) e{^{-\theta x}}e{^{-\theta \alpha x}}}}
}
\note{
The \code{\link[stats]{uniroot}} function with default arguments is used to find out the quantiles.
}
\examples{
set.seed(1)
x <- rnwlindley(n = 1000, theta = 1.5, alpha = 1.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dnwlindley(S, theta = 1.5, alpha = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pnwlindley(q, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
pnwlindley(q, theta = 1.5, alpha = 1.5, lower.tail = FALSE)
qnwlindley(p, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
qnwlindley(p, theta = 1.5, alpha = 1.5, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'nwlindley', start = list(theta = 1.5, alpha = 1.5))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Asgharzadeh, A., Bakouch, H. S., Nadarajah, S., Sharafi, F., (2016). A new weighted Lindley distribution with application. \emph{Brazilian Journal of Probability and Statistics}, \bold{30}, 1-27.
}
\seealso{
\code{\link[lamW]{lambertWm1}}, \code{\link[stats]{uniroot}}.
}

