% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{checkIntRules}
\alias{checkIntRules}
\title{Check intensity rules}
\usage{
checkIntRules(intrules, rates, intrequired, nchains, combinations, sn1,
  sn2 = data.frame(), sn3 = data.frame(), sn4 = data.frame())
}
\arguments{
\item{intrules}{character vector specifying the fragments to compare. See
details.}

\item{rates}{character vector with the expected rates given as a string
(i.e. "3/1"). See details.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{combinations}{output of \link{combineChains}}

\item{sn1}{list of chain fragments identified for sn1 position. Output of
\link{chainFrags}.}

\item{sn2}{list of chain fragments identified for sn2 position. Output of
\link{chainFrags}. If required.}

\item{sn3}{list of chain fragments identified for sn3 position. Output of
\link{chainFrags}. If required.}

\item{sn4}{list of chain fragments identified for sn4 position. Output of
\link{chainFrags}. If required.}
}
\description{
Check intensity rules to confirm chains structure.
}
\details{
This function will be employed when the targeted lipid class has
more than one chain.

Taking PG subclass as an example, intensities of lysoPG fragments
(informative for sn1) can be employed to confirm the chains structure
(intrules = c("lysopg_sn1/lysopg_sn1")).
In this case, the intensity of lysoPG resulting from the loss of the FA chain
in sn2 is at least 3 times higher (rates = c("3/1")) than the lysoPG
resulting from the loss of the FA chain in sn1.

For the intrules argument, "/" will be use to separate the fragments to
compare, and "_" will be use to indicate in which list of fragments we
need to look for their intensities. This will depend on the chain fragments
rules defined previiously.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
\keyword{internal}
