% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineChains.R
\name{combineChains}
\alias{combineChains}
\title{Combine chain fragments that could belong to the same precursor.}
\usage{
combineChains(candidates, nchains, sn1, sn2, sn3, sn4)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{sn1}{list of chain fragments identified for sn1 position. Output of
\link{chainFrags}.}

\item{sn2}{list of chain fragments identified for sn2 position. Output of
\link{chainFrags}. If required.}

\item{sn3}{list of chain fragments identified for sn3 position. Output of
\link{chainFrags}. If required.}

\item{sn4}{list of chain fragments identified for sn4 position. Output of
\link{chainFrags}. If required.}
}
\value{
List of data frames with candidate chains structures.
}
\description{
It calculates combinations of chain fragments that sum up the same number of
carbons and double bounds as the precursor.
}
\examples{
\donttest{
dbs <- list(pgdb = LipidMS::pgdb, lysopgdb = LipidMS::lysopgdb,
fadb = LipidMS::fadb, adductsTable = LipidMS::adductsTable)

candidates <- findCandidates(MS1 = LipidMS::mix_neg_fullMS, dbs[["pgdb"]],
ppm = 10, rt = c(min(MS1$RT), max(MS1$RT)), adducts = c("M-H"),
rttol = 3, dbs)

MSMS <- rbind(LipidMS::mix_neg_Ce20, LipidMS::mix_neg_Ce40)
coelfrags <- coelutingFrags(candidates$RT, MSMS, rttol)

classConf <- checkClass(candidates, clfrags = c(227.0326, 209.022, 74.0359),
clrequired = c(F, F, F, F), ftype = c("F", "F", "NL"), ppm_products = 10,
dbs)

sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"), ppm = 10,
dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10, dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
