% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalCop-package.R
\docType{package}
\name{LocalCop-package}
\alias{LocalCop}
\alias{LocalCop-package}
\title{Local likelihood inference for conditional copula models.}
\description{
Fits a bivariate conditional copula \eqn{C(u_1, u_2 | \theta_x)}, where \eqn{\theta_x} is a variable dependence parameter, nonparametrically estimated from a single covariate \eqn{x} via local likelihood.
}
\examples{
# simulate data
set.seed(123)
family <- 5 # Frank copula
n <- 1000
x <- runif(n) # covariate values
eta_fun <- function(x) 2*cos(12*pi*x) # copula dependence parameter
eta_true <- eta_fun(x)
par_true <- BiCopEta2Par(family, eta = eta_true)
udata <- VineCopula::BiCopSim(n, family=family,
                              par = par_true$par)

# bandwidth and family selection
bandset <- c(.01, .04, .1) # bandwidth set
famset <- c(2, 5) # family set
n_loo <- 100 # number of leave-one-out observations in CV likelihood calculation
system.time({
  cvsel <- CondiCopSelect(u1= udata[,1], u2 = udata[,2],
                          x = x, family = famset, band = bandset,
                          xind = n_loo)
})

# compare estimates to true value
xseq <- cvsel$x
famsel <- cvsel$cv$family
bandsel <- cvsel$cv$band
etasel <- cvsel$eta
clrs <- c("red", "blue", "green4")
names(clrs) <- bandset

plot_fun <- function(fam) {
  nband <- length(bandset)
  if(fam == 2) {
    famind <- 1:nband
    main <- "Student-t Copula"
  } else {
    famind <- nband+1:nband
    main <- "Frank Copula"
  }
  plot(xseq, BiCopEta2Tau(family, eta = eta_fun(xseq)),
       type = "l", lwd = 2, ylim = c(-.5, .5),
       xlab = expression(x), ylab = expression(tau(x)),
       main = main)
  for(ii in famind) {
    lines(xseq, BiCopEta2Tau(fam, eta = etasel[,ii]),
          col = clrs[as.character(bandsel[ii])], lwd = 1)
  }
  legend("bottomright", fill = clrs,
         legend = paste0("band_", bandsel[famind],
                         " = ", signif(cvsel$cv$cv[famind], 3)))
}

oldpar <- par(mfrow = c(1,2))
plot_fun(2)
plot_fun(5)
par(oldpar)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mlysy/LocalCop}
  \item Report bugs at \url{https://github.com/mlysy/LocalCop/issues}
}

}
\author{
\strong{Maintainer}: Martin Lysy \email{mlysy@uwaterloo.ca}

Authors:
\itemize{
  \item Elif Acar \email{elif.acar@umanitoba.ca}
}

Other contributors:
\itemize{
  \item Alan Kuchinsky [contributor]
}

}
