% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_scheme.R
\name{color_scheme}
\alias{color_scheme}
\title{Get color scheme}
\usage{
color_scheme(Plan, expand = NULL, names = NULL, show = TRUE)
}
\arguments{
\item{Plan}{Character, 'Plan1' to 'Plan10' are optional.}

\item{expand}{Numeric, default:NULL. Numeric indicating numbers to expand color scheme into colorRamp}

\item{names}{Character string. Names to assign for color scheme.}

\item{show}{Logical. If show assigned color in plot panel. Default:TRUE.}
}
\value{
If parameter 'names' is not given, 'color_scheme' returns character string including color scheme.When 'names' is set,'color_scheme' returns named vector of color scheme.
}
\description{
color_scheme() can generate color scheme from nine color scheme database and expand into colorRamp
}
\note{
1.Parameter 'names' is strongly recommended to assign for fixed color scheme, see details in ggplot::scale_color_manual
}
\examples{
### Commonly used example ###
my_color <- color_scheme(
  Plan = "Plan1",
  names = c("Treatment1", "Treatment2")
)

### Generate colorRamp still based on 'Plan1'
my_color <- color_scheme(
  Plan = "Plan1",
  expand = 4,
  names = c("Treatment1", "Treatment2", "Treatment3", "Treatment4")
)

### View color scheme from plan1 to plan10 in 'Plots' interface ###
color_scheme(Plan = "Plan1")
color_scheme(Plan = "Plan2")
color_scheme(Plan = "Plan3")
color_scheme(Plan = "Plan4")
color_scheme(Plan = "Plan5")
color_scheme(Plan = "Plan6")
color_scheme(Plan = "Plan7")
color_scheme(Plan = "Plan8")
color_scheme(Plan = "Plan9")
color_scheme(Plan = "Plan10")
}
